﻿
Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn;
$DomainName = (Get-ADDomain).DNSRoot
$subject = "Outlook Forwarding Status in $DomainName"
$priority = "Normal"
$smtpServer = "EX16"
$emailFrom = "EX16@ndsedv.de"
$emailTo = "nds@ndsedv.de"
$port = 25
$at = "C:\Temp\OutlookForwarding.txt"
$body = "Outlook Forwarding & Redirect Report"

$Report = Get-Mailbox -ResultSize unlimited | Get-InboxRule -ErrorAction SilentlyContinue | Where-Object {($_.redirectto -ne $null) -or ($_.forwardto -ne $null)} | Select-Object MailboxOwnerID,name,@{Name="from";Expression={$_.from -join ','}},@{Name="RedirectTo";Expression={$_.RedirectTo -join ','}},@{Name="ForwardTo";Expression={$_.ForwardTo -join ','}},@{Name="ForwardAsAttachmentTo";Expression={$_.ForwardAsAttachmentTo -join ','}},RuleIdentity

$Head = @"
<style>
  body {
    font-family: "Arial";
    font-size: 8pt;
    }
  th, td, tr { 
    border: 1px solid #e57300;
    border-collapse: collapse;
    padding: 5px;
    text-align: center;
    }
  th {
    font-size: 1.2em;
    text-align: left;
    background-color: #003366;
    color: #ffffff;
    }
  td {
    color: #000000;
     
    }
  .even { background-color: #ffffff; }
  .odd { background-color: #bfbfbf; }
  h6 { font-size: 12pt; 
       font-color: black;
       font-weight: bold;
       }
 
 text { font-size: 10pt;
        font-color: black;
        }
 }
</style>
"@

$Report | Sort-Object MailboxOwnerID | Format-Table

[string]$body = [PSCustomObject]$Report | Select-Object MailboxOwnerID,name,from,RedirectTo,ForwardTo,ForwardAsAttachmentTo,RuleIdentity | Sort-Object -Property MailboxOwnerID | ConvertTo-HTML -Head $head -Body "<h6>Bei Fragen - Jörn Walter</h6></font>"

Send-MailMessage -To $emailTo -Subject $subject -BodyAsHtml $body -SmtpServer $smtpServer -Port $port -From $emailFrom -Priority $priority -Encoding UTF8